import os
import warnings
import types
import argparse

import yaml



def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('file', type=argparse.FileType('r'),
                        help='YAML file to parse')

    args = parser.parse_args()

    obj = yaml.load(args.file)

    groups = []
    for group in obj['groups']:
        if isinstance(group, list):
            name = os.path.commonprefix(group)
            groups.append(dict(name=name, members=group))
        elif isinstance(group, types.StringTypes):
            groups.append(dict(name=group, members=group))
        elif isinstance(group, dict):
            groups.append(group)
        else:
            warnings.warn('bad value for group.')
    print groups


if __name__ == '__main__':
    main()
