% doit2.m
%
% This script runs a variety of scripts to produce a colour surface contour map of
% a particular property specified by the user
%
% DAF 10/3/94 (after a script by WRG)
%

% add path of m-files to enable surface plotting
%

% get user input
%
varstr=input('Name of Property to be plotted? ','s');
gridfilename = input ('Name of grid to use? ', 's' );
plotdepth=input('Depth to plot at in m (suggested: 3 m)? ');
flag=input('Would you like to specify plotted variable range (yes=1, no=0)? ');
cyear=input('Year of Cruise to be viewed (93 or 94)? ');
crnum=input('Cruise number? ');
legnum=input('Cruise leg number (1 or 2)? ');

% assign certain variables depending on what the property being plotted

sfcdepth=3;
if (strcmp(varstr, 'salt'))
   vmax=33; vmin=28; titpiece='Salinity (psu)';
elseif (strcmp(varstr,'temp'))
   vmax=15; vmin=3; titpiece='Temperature (oC)';
elseif (strcmp(varstr,'alex'))
   vmax=100; vmin=0; titpiece='Alexandrium tamarense cells';
elseif (strcmp(varstr,'topo'))
   vmax=150; vmin=0; titpiece='topography (m)';
end

if flag
   vmax=input('Maximum of displayed value (e.g., for salinity 33)? ');
   vmin=input('Minimum of displayed value (e.g., for salinity 28)? ');
end
% call dozgrid2 to do processing and plotting of data
% note, we have chosen a default value of 5 grid points for influence of a
% given cell of data, 3 is a default to approximate surface with 3 m data
%
dospgrid(varstr,gridfilename,cyear,crnum,legnum,plotdepth,vmin,vmax,5);


% label plot
fs=9;
title(['Surface ',titpiece,' ,GOM ',num2str(cyear),' Cruise ', ...
num2str(crnum),' leg ',num2str(legnum)],'fontsize',fs);
xlabel('longitude','fontsize',fs);
ylabel('latitude','fontsize',fs);






%set(gca,'xtick',[-71 -70.5 -70 -69.5 -69 -68.5]);
%set(gca,'ytick',[42 42.5 43 43.5 44]);
%mapax(60,30);
%set(gca,'fontsize',fs);





