function tsepic2cdf(tsepicfile,ecom3dfile);
%function tsepic2cdf(tsepicfile,ecom3dfile);
if(nargin<2),ecom3dfile='ecom3d.cdf',end
if(nargin<1),tsepicfile='tsepic.cdf',end
loc=mcvgt(tsepicfile,'loc');
[d,x,y]=kslice(ecom3dfile,'depth');
loc=loc.';
[m,n]=size(loc);
[e,jd]=tselev(tsepicfile);

for i=1:m,
  ii=loc(i,1);
  jj=loc(i,2);
  xts(i)=x(ii,jj);
  yts(i)=y(ii,jj);
end
sp=[xts(:) yts(:)];
saveascii('sta.sp',sp,'%10.2f %10.2f\n');
!sp2ll sta
load sta.ll

vnames='elev';
start=gregorian(jd(1));
dt=3600;
wdepth=0;
idepth=0;
units=['m'];
cmt='Elevation from river run';

for i=1:m,
  cdfname=sprintf('sta%3.3d.cdf',i);
  make_ts(cdfname,e(:,i),vnames,sta(i,2),sta(i,1),start,dt,wdepth,idepth,units,cmt,'1234');end
