function [u,x,z,u2,x2,z2] = ecom_jslice(cdf,var,time,jindex,irange)
%ECOM_JSLICE:  returns a vertical slice along j=jindex, ECOM file
%
% The variable must be 4D.
%
% USAGE:
% >> [u,x,z,u2,x2,z2] = ecom_jslice2(cdf,var,time,jindex,[irange])
%        u = the selected variable
%        x = distance in *km* (assuming x units in netCDF file are in meters)
%        z = depth in m
%        jindex = j index along which slice is taken
%        irange = imin and imax indices along slice (optional).  If this
%           argument is not supplied the default takes all the I indices
%           except for the first and last, which are always "land" cells.
%
% see also ISLICE, KSLICE, ZSLICE, ZSLICEUV, KSLICEUV
%    
if (nargin <4) ,
  help jslice; return
end
mexcdf('setopts',0);
ncid=mexcdf('open',cdf,'nowrite');
if(ncid==-1),
  disp(['file ' cdf ' not found'])
  return
end
[name, nx]=mexcdf('diminq',ncid,'xpos');
[name, nz]=mexcdf('diminq',ncid,'zpos');
if(exist('irange')),
  irange(1)=max(1,irange(1));
  irange(2)=min(nx-1,irange(2));
  istart=irange(1)-1;
  icount=irange(2)-irange(1)+1;
else
  istart=0
  icount=nx;
end
  u2=mexcdf('varget',ncid,var,[(time-1) 0 (jindex-1) istart],...
       [1 nz 1 icount],1);
if nargout>1,
  d=mexcdf('varget',ncid,'depth',[(jindex-1) istart],[1 icount],1);
  ind=find(d==-99999.);
  d(ind)=d(ind)*nan;
  u2(ind,:)=u2(ind,:)*NaN;
  sigma2=mexcdf('varget',ncid,'sigma',0,nz,1);

% assume we are slicing a variable defined at 
% at the center of the sigma level (t,s,u,v,km)

  sigma=0.5*(sigma2(1:nz-1)+sigma2(2:nz));
  h1=mexcdf('varget',ncid,'h1',[(jindex-1) istart],[1 icount],1);
  x2=[0; cumsum(h1)/1000.];    % x location of left hand sides of cells

% here we are assigning the x location of the grid cell center to the data
% (t,s,km)  Variables u,v will be shifted 1/2 grid cell

  x=0.5*(x2(1:end-1)+x2(2:end));  % x location of cell midpoints
  d2=[d(1); 0.5*(d(1:end-1)+d(2:end))];

% expand x and z values into 2D arrays
  x=x*ones(1,nz-1);
  x2=x2(1:end-1)*ones(1,nz);
  z2=d2*(sigma2');
  z=d*(sigma');
end
u=u2(:,1:nz-1);
keyboard
mexcdf('close',ncid);
