function [x,y,d,xi,yi]=plotsta(ecomcdf,tscdf,iplot);
% PLOTSTA Plots time series output locations on map
% and numbers the stations 
%function [x,y,d,xi,yi]=plotsta(ecomcdf,tscdf,iplot);
[d,x,y]=kslice(ecomcdf,'depth');
[im,jm]=size(d);
loc=mcvgt(tscdf,'loc');
loc=loc.';  %columnize
ind=find(loc(:,1)>=1 & loc(:,1)<=im & loc(:,2)>=1 & loc(:,2)<=jm);
[m,n]=size(loc); 
xi=loc(:,1)*nan;
yi=loc(:,2)*nan;
for i=1:length(ind);
  xi(ind(i))=x(loc(ind(i),1),loc(ind(i),2));
  yi(ind(i))=y(loc(ind(i),1),loc(ind(i),2));
end
if nargin==3,
  pslice(x,y,d);
  line(xi,yi,'linestyle','none','color','black',...
   'marker','.','markersize',20);
  line(xi,yi,'linestyle','none','color','white',...
   'marker','.','markersize',14);
  for i=1:m;
%    text(xi(i),yi(i),int2str(i),'color','white','fontsize',20);
    text(xi(i),yi(i),int2str(i),'color','black','fontsize',18,'fontweight','bold');
    text(xi(i),yi(i),int2str(i),'color','white','fontsize',18);
  end 
end
