function [u,y,z,u2,y2,z2] =ecom_islice(cdf,var,time,iindex,jrange)
%ECOM_ISLICE  returns a vertical slice along i=iindex 
%           from an ECOMxx.CDF or POM.CDF file.
%
%     The variable must be a function of x, y, z and time: (e.g. salinity)
%       USAGE: [u,y,z]=islice(cdf,var,time,iindex,[jrange])
%        u = the selected variable
%        y = distance in *km* (assuming y units in netCDF file are in meters)
%        z = depth in m
%        iindex = I index along which slice is taken
%        jrange = jmin and jmax indices along slice (optional).  If this
%           argument is not supplied the default takes all the J indices
%           except for the first and last, which are always "land" cells.
%
%
% see also JSLICE, KSLICE, ZSLICE, ZSLICEUV, KSLICEUV
%
if (nargin < 4) ,
  help islice; return
end
mexcdf('setopts',0);
ncid=mexcdf('open',cdf,'nowrite');
if(ncid==-1),
  disp(['file ' cdf ' not found'])
  return
end
[name, ny]=mexcdf('diminq',ncid,'ypos');
[name, nz]=mexcdf('diminq',ncid,'zpos');
if(exist('jrange')),
  jrange(1)=max(1,jrange(1));
  jrange(2)=min(ny-1,jrange(2));
  jstart=jrange(1)-1;
  jcount=jrange(2)-jrange(1)+1;
else
  jstart=1
  jcount=ny-2;
end
u2=mexcdf('varget',ncid,var,[(time-1) 0 jstart (iindex-1)],...
      [1 nz jcount 1],1);
if nargout>1,
  d=mexcdf('varget',ncid,'depth',[jstart (iindex-1)],[jcount 1],1);
  ind=find(d==-99999.);
  d(ind)=d(ind)*0;
  u2(ind,:)=u2(ind,:)*NaN;
  sigma=mexcdf('varget',ncid,'sigma',0,nz,1);
  sigma2=0.5*(sigma(1:nz-1)+sigma(2:nz));

% get one more h2 value than data so we can returnvtnalue 
  h2=mexcdf('varget',ncid,'h2',[jstart-1 (iindex-1)],[jcount+1 1],1);

  y2=[cumsum(h2)/1000.];  % for shading 'faceted' or 'flat'
  y=y(1:ny-1)*ones(1:ny-1,nz);
  z2=d*(sigma');
  ind=find(isnan(z2));
  z2(ind)=zeros(size(ind));
end
u=u2(:,1:nz-1);
y2=y2(:,1:nz-1);
z=z2(:,1:nz-1);

mexcdf('close',ncid);
