function evap=evaporation(H_l);
% EVAPORATION: Computes evaporation rate based on Latent Heat Flux (H_l)
%  Basically, we just divide the latent heat flux by 
%    the latent heat of vaporation (L_v) (p. 607 of Gill) and by the 
%    density of water (rho). 
%
%          A=hfbulktc(wds,10.,atemp.,10....);   % run airsea bulk calc
%          H_l=A(:,2);   % extract Latent Heat Flux 
%   Usage: evap=evaporation(H_l);  % calculate evaporation
%
%    Inputs:  H_l  = Latent Heat Flux in (watts/m2)
%    Output:  evap = evaporation rate in m/year
%
%   Rich Signell  (rsignell@usgs.gov)  1-Sep-1999
%
L_v=2.5e6; % Latent heat of vaporation 
          %(approximation to Gill's formula A4.9, p 607.

rho=1000;  % kg/m3  approximation to water density

evap=-H_l/L_v/rho*(3600*24*365.);  % convert from m/s to m/year
evap=max(evap,0.)   %  evaporation rate should not be negative
