package gov.cca.ports;

/** Mapping of standard event types in the component lifecycle to
    strings and integers.

    In decoding the EventData messages, each kind of event here
    requires details to make sense. The details string is composed
    of information we want to eventually be in XML. 
    Basic info types:
    FID - framework ID string, 
          likely to be the component id of an outermost container.
    CID - existing local container ID string, 
    CN - component local name, within its container.
    pport - name of a provides port as known to the component defining it.
    uport - name of a uses port as known to the component defining it.
    class - name of port type or of component type as registered in factory.
    Prefixes/suffixes:
    caller - the using side of a connection
    callee - the used side of a connection
    requested - the name is a suggestion.
*/
public interface StandardEventType {

  /** When digesting an alleged string or int type,
      it was found not to be in the standard. 
   */
  public static final int NONE = -2;
  public static final String NONE_string = "NONE";

  /** Somebody lost their cookies. Should never be deliberately sent 
      or received.
    */
  public static final int Error = -1;
  public static final String Error_string = "Error";

  /** The enumerated value type for a listener to indicate it wants all
      notices. Never delivered to a listener.
   */
  public static final int ALL = 0;
  public static final String ALL_string = "ALL";

  /** A connection may soon be made.  (Assuming no errors in process).
      The detail string is of form
      FID CID caller-CN callee-uport callee-CN callee-pport.
   */
  public static final int ConnectPending = 1;
  public static final String ConnectPending_string = "ConnectPending";

  /** A connection recently made. The detail string is of form
      FID CID caller-CN caller-uport callee-CN callee-pport.
   */
  public static final int Connected = 2;
  public static final String Connected_string = "Connected";

  /** A connection may soon be unmade. (Assuming no errors in process).
      The detail string is of form
      FID CID caller-CN caller-uport callee-CN callee-pport. 
   */
  public static final int DisconnectPending = 3;
  public static final String DisconnectPending_string = "DisconnectPending";

  /** A connection recently unmade. The detail string is of form
      FID CID caller-CN caller-uport callee-CN callee-pport. 
   */
  public static final int Disconnected = 4;
  public static final String Disconnected_string = "Disconnected";

  /** A component creation requested. (Assuming no errors in process).
      The detail string is of form
      FID CID class CN-requested.
   */ 
  public static final int ComponentAddPending = 5;
  public static final String ComponentAddPending_string = "ComponentAddPending";

  /** A component newly created.
      The detail string is of form
      FID CID class CN.
   */
  public static final int ComponentAdded = 6;
  public static final String ComponentAdded_string = "ComponentAdded";

  /** A component deletion requested. 
      The detail string is of form
      FID CID CN.
   */
  public static final int ComponentDeletePending = 7;
  public static final String ComponentDeletePending_string = "ComponentDeletePending";

  /** A component deletion completed.
      The detail string is of form
      FID CID CN.
   */
  public static final int ComponentDeleted = 8;
  public static final String ComponentDeleted_string = "ComponentDeleted";

  /** A provides port is being added (but not yet available). (Assuming no errors in process).
      The detail string is of form
      FID CID CN pport-requested.
   */
  public static final int PortAddPending = 9;
  public static final String PortAddPending_string = "PortAddPending";

  /** A provides port was added and is available.
      The detail string is of form
      FID CID CN pport.
   */
  public static final int PortAdded = 10;
  public static final String PortAdded_string = "PortAdded";

  /** A provides port is being removed, but is still available.
      The detail string is of form
      FID CID CN pport.
   */
  public static final int PortRemovePending = 11;
  public static final String PortRemovePending_string = "PortRemovePending";

  /** A provides port has been removed and is no longer available.
      The detail string is of form
      FID CID CN pport.
   */
  public static final int PortRemoved = 12;
  public static final String PortRemoved_string = "PortRemoved";
  
  /** A uses port is about to be registered. (Assuming no errors in process).
      The detail string is of form
      FID CID CN uport-requested.
   */
  public static final int PortRegisterPending = 13;
  public static final String PortRegisterPending_string = "PortRegisterPending";

  /** A uses port was registered.
      The detail string is of form
      FID CID CN uport.
   */
  public static final int PortRegistered = 14;
  public static final String PortRegistered_string = "PortRegistered";

  /** A uses port is about to be unregistered.
      The detail string is of form
      FID CID CN uport.
   */
  public static final int PortUnregisterPending = 15;
  public static final String PortUnregisterPending_string = "PortUnregisterPending";

  /** A uses port has been unregistered.
      The detail string is of form
      FID CID CN uport.
   */
  public static final int PortUnregistered = 16;
  public static final String PortUnregistered_string = "PortUnregistered";

  /** A port is about to be fetched for use with getPort.
      The detail string is of form
      FID CID CN uport.
   */
  public static final int PortFetchPending = 17;
  public static final String PortFetchPending_string = "PortFetchPending";

  /** A port has been fetched with getPort.
      The detail string is of form
      FID CID CN uport.
   */
  public static final int PortFetched = 18;
  public static final String PortFetched_string = "PortFetched";

  /** A port is about to be released from use with releasePort.
      The detail string is of form
      FID CID CN uport.
   */
  public static final int PortReleasePending = 19;
  public static final String PortReleasePending_string = "PortReleasePending";

  /** A port has been released with releasePort.
      The detail string is of form
      FID CID CN uport.
   */
  public static final int PortReleased = 20;
  public static final String PortReleased_string = "PortReleased";

  /** A factory is now available.
      The detail string is of form FID CID CN.
   */
  public static final int FactoryOpened = 21;
  public static final String FactoryOpened_string = "FactoryOpened";

  /** A factory is no longer available for more creations.
      It may remain open for destruction of previously created
      items, however. ComponentDeleted is the final message in the
      lifecycle of the component, factory or not.
      The detail string is of form FID CID CN.
   */
  public static final int FactoryClosed = 22;
  public static final String FactoryClosed_string = "FactoryClosed";


}
