package gov.cca.ports;
import gov.cca.*;

/** PrintfPort for use in building components.

 A just-print-it port.  Tremendously useful. 
The framework implementation of this port is very likely
to do things such as direct the out, error, and log channels
to line-oriented files or gui windows or /dev/null under the covers.

These are intended for debugging and control information,
not bulk data transfer. The design, or lack thereof,
is to be expected from C coders hacking in java. The
clued world is invited to do better, define a cerr/cout/clog
port, etc.

We contemplate 3 devices (at least for prototyping purposes)

The OUT device "p" is likely to be used to communicate back
to UI's from 'special' components.

The ERROR device "e" is likely to be echoed to a user but
not otherwise interpretted.

The LOG device is likely to be directed to a logging service
or raw file and not seen by anybody ever.

It is good practice for components implementing this
interface to return immediately (minimizing cost) if
noone is listening even though the component insists
on talking.

    @author Ben Allan, 9/30/1999, Sandia National Laboratories.
   @version $Id: PrintfPort.java,v 1.1 2000/08/10 21:08:18 baallan Exp $
*/
public interface PrintfPort extends Port { 


  /** Output a string on out device  */
  public void p(String s);
  /** Output a string on out device with added \n  */
  public void pn(String s);

  /** Output a string on err device  */
  public void e(String s);
  /** Output a string on err device with added \n  */
  public void en(String s);

  /** Output a string on log device  */
  public void l(String s);
  /** Output a string on log device with added \n  */
  public void ln(String s);


}
