package gov.cca.ports;
import gov.cca.*;

/** A service to issue connection events (assumed scope is the
component from whose Services interface the FrameworkConnectionEventService 
is fetched.
This service interface is compatible with a direct-connected framework.
@see Component 
@see ConnectionEvent
*/
public interface FrameworkConnectionEventService extends Port {
  /** Issue an event to all listeners registered for it.
      @param event must be an object supporting the ConnectionEvent interface.
   */
  public void fireConnectionEvent(ConnectionEvent evt);

}
