package gov.cca.ports;
import gov.cca.*;

/** A service to alert a component as when connections are made or broken; it is
reasonable to expect this service to be immediately available and fetchable during
a setServices call. This service interface is compatible with a direct-connected
framework.
@see Component 
*/
public interface ConnectionEventService extends Port {
  /** Sign up to be told about connection activity.
      @param connectionEventType must be one of the integer values defined in
   @see ConnectionEvent
   */
  public void addConnectionEventListener(int connectionEventType, ConnectionEventListener l);

  /** Ignore future ConnectionEvents of the given type.
      Removing a non-added listener is not an error. 
      @param connectionEventType must be one of the integer values defined in
   @see ConnectionEvent
   */
  public void removeConnectionEventListener(int connectionEventType, ConnectionEventListener l);
}
