package gov.cca.ports;
import gov.cca.*;
/** Base event interface components wishing to know about their connectedness
(used or provided ports) must listen for. 
This interface represents a large simplification and callback
style imposed over the general EventService layer.
This interface contains only enough information to be useful
in the scope of the particular Component instance receiving
the event.
*/
public interface ConnectionEvent extends StandardEventType {

  /** Returns the integer from those defined that describes the event.
      <p>
      The semantics are noted before
      each member of the enum/static constant. We can add in different
      types of connect/disconnect as multiports and
      explicit local/global/sync/async semantics are agreed to in the future.
      </p>

      <p>
      At present we assume that:
      <ul>
      <li> all instances in a component cohort (often thought of as a single
        "parallel component") receive all the events
        and in the same order, but not necessarily globally synchronously.</li>
      <li> for disconnections, within a process the events are delivered first
        to the using component then to the providing component.</li>
      <li> for connections, within a process the events are delivered first
        to the providing component then to the using component.</li>
      </ul>

      Clearly some of the assumptions above may not suit a component
      instance in which multiple execution threads act on a
      single instance of the gov::cca::Services object (SMP). The Services
      specification is ambiguous as to whether such a component is even allowed.
      When this is clarified, additional members of the enum may arise,
      in which case the assumptions here apply only to
      ConnectPending, Connected, DisconnectPending, Disconnected types.

  */
  public int getEventType();

  /** Get the PortInfo of the affected Port. */
  public PortInfo getPortInfo();
}
