package gov.cca;

/** This is the framework/container services interface, 
    through which the component accesses the framework
    and (indirectly) other components. */ 
public interface Services {
      /** Fetch a previously registered Port (defined by either addProvide or registerUses). 
          @return Will return the Port (possibly waiting forever to acquire it) or
	  return null. There is an implied contract that the
	  port will remain valid for use by the component until the
	  port is released via releasePort(), or a DisconnectingConnectionEvent is
          dispatched to the component. 
      @throws Exception if named port is not known. */
  public Port getPort(String name) throws Exception;

      /** Fetch a previously registered Port (defined by
      either addProvide or registerUses) and return that
      Port if it is available immediately or return null
      otherwise. There is an implied contract that the
      port will remain valid for use by the component
      until the port is released via releasePort(). */
  public Port getPortNonblocking(String name) throws Exception;

  /** Notifies the framework that this component is finished using this previously
      fetched Port.     
      releasePort() method calls should exactly match getPort() method calls;
      however, an extra call to releasePort() is not an error.
      */
  public void releasePort(String name);

  /** Creates a PortInfo to be used in subsequent calls to describe a Port.
      @see PortInfo */
  PortInfo createPortInfo(String name, String type, String[] properties );

  /** Register a request for a Port that will be retrieved subsequently 
      with a call to getPort(). 
      @throws Exception Registering the same name twice is an error,
      regardless of the associated type or properties in the PortInfo. */
  public void registerUsesPort(PortInfo name_and_type) throws Exception;

  /** Notify the framework that a Port, previously registered by this component,
      is no longer desired. 
      @throws Exception Unregistering a port which is currently in use (i.e.
      an unreleased getPort() being outstanding) is an error. */
  public void unregisterUsesPort(String name) throws Exception;

  /** Exports a Port implemented by this component to the framework.  
      This Port is now available for the framework to connect to other components. 
      @throws Exception Adding an already defined port name (registered or provided)
      is an error.
   */
  public void addProvidesPort(Port inPort, PortInfo name_type_and_props) throws Exception;

  /** Notifies the framework that a previously exported Port is no longer 
      available for use.
   */
  public void removeProvidesPort(String name);

  /** UNADOPTED: Return the Ports this component currently provides. */
  public PortInfo[] getProvidedPorts();

  /** UNADOPTED: Return the Ports this component currently wants. */
  public PortInfo[] getRegisteredPorts();

  /** Get a reference interface for the component to which this Services object belongs. */
  public ComponentID  getComponentID();
}
