package gov.cca;
/**
  This interface abstracts the information needed to understand the
  topology and status of a connection within the local context. 
  This deliberately does not expose
  information about direct vs proxy aspects, network status,
  etc as those are implementation specific.
  This does not have anything to do with multiplex connections, as
  in the multiplex, this interface will characterize any single line.
 */
public interface ConnectionInfo {
  /** @return The id of the "caller" component in the connection. */
  ComponentID getUser();

  /** @return The name of the port used in the "caller" component. */
  String getUserPortName();

  /** @return The id of the "callee" component in the connection. */
  ComponentID getProvider();

  /** @return The name of the port provided in the "callee" component. */
  String getProviderPortName();

  /** @return true if the using component has an unreleased
              getPort(getUserPortName());
              meaning this connection may be in use.
   */
  boolean isInUse();

}
