package gov.cca;

/** An opaque reference to a CCA component. 
    @see Component
*/
public interface ComponentID {
  /** Produce a string that uniquely defines 
      this component reference within all possible frameworks. 
      For parallel implementations, this string will likely be different
      by a processor id across the cohort of a single "spmd instance".
	@return The unique identifier (which is necessarily pretty gorey looking)
            for this component. You probably don't want to show it to
            users, except in debugging desperations.
   */
  public String toString();

  /** Produce the name within the immediate container scope of this
      component. In parallel implementations, all the members of
      the cohort which constitutes a single "spmd instance" will produce
      the same result.
    @return the local to the container name of this instance as known
        by a human-like user.
   */
  public String getLocalName();

  /** Produce the name of the component instance dot qualified 
      to the outermost accessible CCA framework scope. In particular,
      where there are nested frameworks/containers, If the outermost
      container instance is named "A", it contains a container component
      locally named "b", and we're querying the ComponentID of an
      instance inside "b" locally named "C", then we will get back
      "A.b.C".

      In parallel implementations, all the members of
      the cohort which constitutes a single "spmd instance" will produce
      the same result.
    @return the global to the underlying framework human-usage name of this 
            instance.
   */
  public String getGlobalName();

  /** Produce the name of the class of this component as known in its
      container. This is the container pallet alias, not necessarily
      matching the java, C++, or any other language-bound class name.
   */
  public String getClassName();
}
