#ifndef __PRINTFPORT_H__
#define __PRINTFPORT_H__

namespace gov {
  namespace cca {

/** UNADOPTED Standard: A just-print-it port.  Tremendously useful. 
<p>The framework implementation of this port is very likely
to do things such as direct the out, error, and log channels
to files or gui windows under the covers.</p>

<p>These are intended for debugging and control information,
not bulk data transfer. The design, or lack thereof,
is to be expected from C coders hacking in c++. The
clued world is invited to do better, define a cerr/cout/clog
port, etc.</p>

<p>We contemplate 3 devices (at least for prototyping purposes)</p>

<p>The OUT device "p" is likely to be used to communicate back
to UI's from 'special' components.</p>

<p>The ERROR device "e" is likely to be echoed to a user but
not otherwise interpretted.</p>

<p>The LOG device is likely to be directed to a logging service
or raw file and not seen by anybody ever.</p>

<p>It is good practice for components implementing this
interface to return immediately (minimizing cost) if
noone is listening even though the component insists
on talking.</p>

<p>The const versions of the member functions exist to
shut up the Solaris compilers.</p>

<p>C++ cout stream fascists should look elsewhere for a port to their liking.</p>
*/
class PrintfPort : public virtual Port {

public:

  /** obligatory vdtor */
  virtual ~PrintfPort(){}

  /** Output a string on out device ... ala printf */
  virtual void p(char* fmt, ...) =0;
  /** Output a string on out device ... ala printf */
  virtual void p(char const* fmt, ...) =0;
  /** Output a string on out device with added \n ... ala printf */
  virtual void pn(char * fmt, ...) =0;
  /** Output a string on out device with added \n ... ala printf */
  virtual void pn(const char * fmt, ...) =0;

  /** Output a string on err device ... ala printf */
  virtual void e(char* fmt, ...) =0;
  /** Output a string on err device ... ala printf */
  virtual void e(const char* fmt, ...) =0;
  /** Output a string on err device with added \n ... ala printf */
  virtual void en(char* fmt, ...) =0;
  /** Output a string on err device with added \n ... ala printf */
  virtual void en(const char* fmt, ...) =0;

  /** Output a string on log device ... ala printf */
  virtual void l(char* fmt, ...) =0;
  /** Output a string on log device ... ala printf */
  virtual void l(const char* fmt, ...) =0;
  /** Output a string on log device with added \n ... ala printf */
  virtual void ln(char* fmt, ...) =0;
  /** Output a string on log device with added \n ... ala printf */
  virtual void ln(const char* fmt, ...) =0;

};


  } ENDSEMI //cca
} ENDSEMI //gov


#endif //__PRINTFPORT_H__
