#ifndef MPIBorrow_h_seen
#define MPIBorrow_h_seen

//requires:
//#include <cca.h>
//#include <mpi.h>

namespace gov {
  namespace cca {

/** UNADOPTED standard service. Port string name "gov.cca.MPIBorrow". */

class MPIBorrow : public virtual Port {

public:

  /** obligatory vdtor */
  virtual ~MPIBorrow() {}

  /** Get a communicator of the port provider.
   This communicator will be the same instance as the comm of the
   port provider, with all the message collision potential that implies.
   Instances which have a comm covering only a subset of themselves
   may return MPI_COMM_NULL on their "un-covered" processes.
	 @param tagCount Input: The number of tags the borrower wishes to use
	                 all to itself.
   @param tagList Output: Array to be filled with tags available. The
	                        array given is tagCount long.
	 @param key Output: key to be returned when the tags and comm are done
	                    with.
	 @return The comm being borrowed.
  */
  virtual MPI_Comm borrowComm(int tagCount, int *tagList, int &key) = 0;

	/** Return a previously borrowed communicator and tag list.
	 *  @param tagCount Input: The length of tagList.
	 *  @param tagList Input: The tags being returned, tagCount long.
	 *  @param key Input: The key obtained with borrowComm. It is
	 *         an error to attempt to return tags that you didn't receive.
	 *  @return -1 if an error is detected, 0 otherwise.
	 */
	virtual void returnComm(MPI_Comm, int tagCount, int *tagList, int key) = 0;
};

} ENDSEMI //cca
} ENDSEMI //gov

#endif // MPIBorrow_h_seen
