#ifndef KeyValuePort_h_seen
#define KeyValuePort_h_seen

namespace gov {
  namespace cca {

/** UNADOPTED Standard: KeyValuePort for use decorating components with strings external
 * to the implementation of the component.
 * Alternative, misleading names for this would be
 * <pre>
 *   EnvironmentPort (which has too many global connotations)
 *   RegistryPort (which has way too many global connotations)
 *   PropertiesPort (which will be confused with port properties and java Propertie
s...).
 *   ParameterPort (which is already taken in the CCAFFEINE framework.).
 * </pre>
 * <p>This class is deliberately simpler than java Properties, for
 * compatibility with basic c++ implementations.</p>
 * <p>In a reasonable framework, each component will just be
 * automatically decorated with one of these if that framework
 * exposes the component to external agents.</p>
 * <p>The following code fragment illustrates the use of the KeyValuePort
 * by a framework Services implementation to decorate 
 * every component with a properties for the frameworks use.</p>
 * <pre>
 *    int err;
 *    err = addProvidesPort(kvp,createPortInfo("cProps","gov.cca.ComponentProperties",0));
 *    assert(!err); // cannot fail, due to other framework design features
 * </pre>
 * <p>The following code fragment illustrates the use of the port as a service by
 * a component that wants to know/modify what the framework says about it.</p>
 * <pre>
 *   setServices(Services *s) {
 *     int err;
 *     err= s->registerUsesPort(kvp,createPortInfo("sProps","gov.cca.ComponentPropertiesService",0));
 *     assert(!err); // cannot fail, if we adopt it as a well known service.
 *     Port *p = getPort("sProps");
 *     KeyValuePort *kvp = dynamic_cast<KeyValuePort *>(p);
 *     kvp->setValue("gov.babel.guiApplet.URL",
 *                "http://z.ca.sandia.gov/cgi-bin/babel.asp?component=gov.sandia.viz");
 *     s->releasePort("sProps");
 *     s->unregisterUsesPort("sProps");
 *   }
 * </pre>
 * @author Ben Allan, 8/5/2000, Sandia National Laboratories.
 * @version $Id: KeyValuePort.h,v 1.3 2001/04/24 20:13:13 baallan Exp $
 */
class KeyValuePort : public virtual Port { 

public:

  /** obligatory vdtor */
  virtual ~KeyValuePort() {}

  /** Return the value of the requested key.  
      If key unknown, returns null. The value returned is owned by the
      port and should not be destroyed. */
  virtual CONST char * getValue(CONST char * key)=0;

  /** Store the value for the given key, possibly replacing previous.
      The pointers to key, value are not kept -- just copied. 
      Keys cannot contain the whitespace or '='. Returns nonzero on
      bogus input or other error. */
  virtual int setValue(CONST char * key, CONST char * value) =0;

  /** Delete a key and associated value. The deleted value
      is returned, and the caller owns the returned pointer. */
  CFREE virtual char * remove(CONST char * key) =0;

  /** Return NULL-terminated list of all known keys.
      May be the empty list. The caller owns the argv returned,
      but not the strings pointed to by the argv.
      Returns NULL only in the event of malloc failure.
   */
  CFREE virtual char ** getKeys()=0;

};

  } ENDSEMI
} ENDSEMI

#endif //KeyValuePort_h_seen
