#ifndef __GOPORT_H__
#define __GOPORT_H__

namespace gov {
  namespace cca {

/** UNADOPTED Standard: A just-do-it port.  Tremendously useful. 
  The canonical string type-name for this port is "GoPort",
  though it should probably be "gov.cca.GoPort". */
class GoPort : public virtual Port {

public:

  /** obligatory vdtor */
  virtual ~GoPort(){}

  /** Make the component do its thing. 
   *  The component does not throw c++ exceptions except in the
   *  form of returning -2.
   * @return
   * <ul><li> 0 if did ok</li>
   * <li>-1 if had problem,</li><li> -2 if had problem bad enough to shoot
   *  the component in the head or exit the framework.</li> 
   * </ul>
  */
  virtual int go() = 0;
};


  } ENDSEMI
} ENDSEMI


#endif //__GOPORT_H__
