#ifndef DisconnectingConnectionEvent_h_seen
#define DisconnectingConnectionEvent_h_seen

namespace gov {
  namespace cca {

/** UNADOPTED standard implementation: Event delivered to 
    a connection listener before a connection is broken. */
class DisconnectingConnectionEvent : public virtual ConnectionEvent {

private:
  PortInfo *pi;

public:
  DisconnectingConnectionEvent(PortInfo *pi) {
    this->pi = pi;
  }
  /** True if the event informs a connection. (never) */
  int connected() {
    return false;
  }
  /** True if the event informs a disconnection (always) */
  int disconnected() {
    return true;
  }
  /** Get the PortInfo of the affected Port. */
  PortInfo *getPortInfo() {
    return pi;
  }
};


  } ENDSEMI
} ENDSEMI

#endif /* DisconnectingConnectionEvent_h_seen */
