#ifndef ConnectedConnectionEvent_h_seen
#define ConnectedConnectionEvent_h_seen

namespace gov {
  namespace cca {

/** UNADOPTED standard implementation: Event delivered after
    a new connection has been made. */
class ConnectedConnectionEvent : public virtual ConnectionEvent {

private:
  PortInfo *pi;

public:
  ConnectedConnectionEvent(PortInfo *pi_) { 
    pi = pi_; 
  }
  /** True if the event informs a connection. (always) */
  int connected() {
    return true;
  }
  /** True if the event informs a disconnection (never) */
  int disconnected() {
    return false;
  }
  /** Get the PortInfo of the affected Port. */
  PortInfo *getPortInfo() {
    return pi;
  }
};

  } ENDSEMI
} ENDSEMI

#endif // ConnectedConnectionEvent_h_seen

