#ifndef __CCA_H__
#define __CCA_H__


/**  Use of the C/C++ const modifier at compile time is not allowed in
 *    the standard, as it is unenforceable. It is nonetheless a nice
 *    mnemonic to assist communication among scientific
 *    programmers.
 */
#define CONST
/** Some compilers are finicky about whether namespaces are closed
    with a "}" or a "};"
    If a compiler is not picky, then "} ;" is preferred.
 */
#define ENDSEMI ;  // use of this macro is deprecated
#define CCA_NAMESPACE_ENDSEMICOLON ;

/** CFREE/CDELETE indicates returned pointers are owned by the caller and should
    be free()'d or deleted at the earliest appropriate time. 
    These hints will be going away, with the introduction of a memory
    management model in the cca specification for c++.
*/
#define CFREE
#define CDELETE


namespace gov {
/** 
 * <p>The spec lives in C++ namespace gov::cca:: or else as gov_cca_.</p>
 * <p>The use of certain recent C++ language features, specifically
 *  templates, and the Standard Template Library
 *  is not mandated by the CCA interface specifications. 
 *  These features
 *  are not sufficiently portable to the computing systems of interest to
 *  scientists in the Department of Energy. Use of these C++ features 
 *  in component implementations or framework implementations is not
 *  prohibited, however, as not all components may have a strong
 *  portability requirement. </p>
 *  <p>
 */
  namespace cca {

    /** UNADOPTED: A class to support the runtime introspection of the CCA version.
        The int returning functions are capitalized because sysmacros.h
        #defines both major() and minor(), sheesh. */
    class Version {
    public:
      /** The descriptive source release string. */
      static CONST char *name(); 
      /** The dot notation release number string; major.minor.patch.  */
      static CONST char *id();
      /**@ Revision numbering scheme will be rigorously followed after
           1_0_0. */
      //@{
      /** Major version; increments with binary incompatible changes 
          in this header. */
      static CONST int Major(); 
      /** Minor revision; increments with binary incompatible changes in
          well known ports, including changes in namings expressed with
          string name or type arguments. Changes in the spec but outside
          this header. */
      static CONST int Minor(); 
      /** Patch revision; binary compatible changes, such as addition of
          new common port definitions. */
      static CONST int Patch(); 
      //@}
    };

#if 0 // not needed, as doesn't make generic containers any easier
#define CCA_OBJECTCOUNTABLE_DEFINED
    /** It is an open question whether
      the C++ binding of CCA should go further and include 
      add/deleteReference, as would seem to be needed if we are to have
      memory-safe container components that are portable across frameworks. */
    class ObjectCountable {
    public:
      /** Obligatory virtual destructor. */
      virtual ~ObjectCountable (){}
      /** */
      virtual void addReference() = 0;
      virtual void deleteReference() = 0;
    };
#endif // objectcountable bypass

    /** A tag interface to identify an interface capable of being exported to
	or imported from a CCA component. */
    class Port  {
    public:
      /** obligatory virtual destructor */
      virtual ~Port (){}
    };

    /** An interface that describes a Port. */
    class PortInfo  {
    public:
      /** obligatory virtual destructor */
      virtual ~PortInfo(){}

      /** Returns the type for this Port.  This string corresponds to the 
	  interface name of the port, but may not be identical. */ 
      virtual CONST char* getType() CONST = 0;

      /** Returns the instance name for this Port.
          This name must be unique within the scope of 
          the CCA component which uses or provides this port.*/
      virtual CONST char* getName() CONST = 0;

      /** Returns the string value for this property,
          or 0 if it is undefined. */
      virtual CONST char* getProperty(char* name) = 0;

    };

    /** An opaque reference to a Component. */
    class ComponentID  {
    public:
      /** obligatory virtual destructor */
      virtual ~ComponentID() {}

      /** Produce a string that, within the current
          framework, that uniquely defines this component reference.
         @return toString is probably a bad choice of name for this
            method as toString is likely to be used in a more
            Java-conventional sense. */
      virtual CFREE char* toString()=0;


    };

    /** The handle through which the component communicates with its
        containing framework. */
    class Services  {
    public:
      /** obligatory virtual destructor */
      virtual ~Services (){}

      /** Creates a PortInfo to be used in subsequent
          calls to describe a Port. The arguments given are copied, not kept.
          properties is an even length list (argv) of key/value pairs 
          terminated by a NULL key. Note that names of Ports in a 
          component are not distinct for used and provided ports. 
          Standard properties: (UNADOPTED, extensible list)
                gov.cca.port.minConnections (int >= 0; default 0)
		gov.cca.port.maxConnections (int >= 1, default 1)
		gov.cca.port.proxyAllowed   (true,false; default false)
      */
      virtual PortInfo *  createPortInfo(CONST char *name, CONST char *type, CONST char** properties) = 0;

      /**  Fetch a port from the framework. Normally this means a uses port.
      If no uses port is connected and a provided port of the name requested
      is available, the component will be handed back that port.
       Returns NULL if no provided port or uses port connection matches name.
       @see Services.java; UNADOPTED C++ definition of "an error occurs".
   */
      virtual Port *getPort(CONST char *name) = 0;

      /** Free's the port indicated by the instance name for modification
	  by the component's containing framework.  After this call the
	  port will not be valid for use until getPort() is called
	  again.*/
      virtual void releasePort(CONST char *name) = 0;
#ifdef ROB

      /** Fetch multiple uses ports from the framework
          of the same name/portInfo.
          Returns a null-terminated array of Ports in c++ and just
          an array of Ports in java. Useful in implementing high
          performance multiplexers and multiple connects which
          are more complicated than 'message broadcast'.
          Q: While getMultipleUsesPort is outstanding, can/should
             new connections be made? Probably not.
       */
      virtual Port *getMultipleUsesPort(CONST char *name) = 0;

      /** Free's the ports indicated by the instance name
          for modification by the component's containing framework.
      */
      virtual void releaseMultipleUsesPort(CONST char *name) = 0;
#endif //ROB

      /** Notifies the framework that a port described by PortInfo
	  may be used by this component. The portinfo is obtained 
      from createPortInfo. Returns nonzero if there is an error
      in registering, such as bad PortInfo or already registered.
       @see Services.java; UNADOPTED C++ definition of "an error occurs".
      */
      virtual int registerUsesPort(PortInfo *name_and_type) = 0;

      /** Notify the framework that a Port, previously
          registered by this component, is no longer desired.
          Returns nonzero if the port is still in use, ignoring
          the unregister request.
       @see Services.java; UNADOPTED C++ definition of "an error occurs".
       */
      virtual int unregisterUsesPort(CONST char *name) = 0;

      /** Exports a Port implemented by this component to the framework.  
	  This Port is now available for the framework to
	  connect to other components. The PortInfo is obtained 
      from createPortInfo. Returns nonzero if addProvidesPort fails,
      for example, because that name is already provided.
       @see Services.java; UNADOPTED C++ definition of "an error occurs". */
      virtual int addProvidesPort(Port *inPort, PortInfo *name) = 0;

      /** Notifies the framework that a previously exported Port is no longer 
	  available for use. */
      virtual void removeProvidesPort(CONST char *name) = 0;

      /** Get a reference to the component which this 
          Services object belongs. */
      virtual CDELETE ComponentID* getComponentID() = 0; // proposed extension

      /** UNADOPTED: Return the Ports this component currently provides.
      Length of the PortInfo array returned is an output argument. */
      virtual CFREE PortInfo** getProvidedPorts(int& length) = 0;

      /** UNADOPTED: Return the Ports this component currently wants. 
      Length of the PortInfo array returned is an output argument. */
      virtual CFREE PortInfo** getRegisteredPorts(int& length)= 0;

    };

    /** Component object model that all CCAComponents must implement. */
    class Component {
    public:
      /** obligatory virtual destructor */
      virtual ~Component(){}

      /** The components containing framework provides services through
	  the Services interface. */
      virtual void setServices(Services *cc)=0;
    };

  } CCA_NAMESPACE_ENDSEMICOLON // end namespace gov.cca
} CCA_NAMESPACE_ENDSEMICOLON // end namespace gov
#endif //__CCA_H_ 
