#include <stdlib.h>
#include <stdio.h>
#include <cca.h>
#include "../include/EG.h"


#include "SimpleStamper.h"
		   
EGNS(SimpleStamper)::SimpleStamper(){
}

EGNS(SimpleStamper)::~SimpleStamper(){
}

void EGNS(SimpleStamper)::setServices(gov::cca::Services *svc){
  this->svc = svc;

  svc->addProvidesPort(this, 
    svc->createPortInfo("in_port", "StringConsumerPort", 0));

  // Remember that if the PortInfo is created but not used in a call to the svc object
  // then it must be freed.
  svc->registerUsesPort(svc->createPortInfo("out0", "StringConsumerPort", 0));
  svc->registerUsesPort(svc->createPortInfo("time0", "TimeProducerPort", 0));
}

void EGNS(SimpleStamper)::setString(const  char* s){

  gov::cca::StringConsumerPort* output = 
    dynamic_cast<gov::cca::StringConsumerPort*> (svc->getPort("out0"));
  if(output == 0) {
    perror("out0 Port unavailable");
  }

  gov::cca::TimeProducerPort* timer = 
    dynamic_cast <gov::cca::TimeProducerPort*> (svc->getPort("time0"));
  if(output == 0) {
    perror("time0 Port unavailable bailing...");
  }

  char* t = timer->getTime();
  char* str = (char*) malloc(512);
  sprintf(str, "%s@%s", s, t);

  output->setString(str);
  free(t);
  svc->releasePort("out0");
  svc->releasePort("time0");
}
