#
# This file is sh-compatible and is provided for other
# components/frameworks to include in their makes or other scripts
# to pick up proper ** INSTALLED ** definitions of our header/library
# locations.  We prefer this approach to writing brittle ccacc, ccaf77,
# ccaf90, and ccaCC wrappers.

# If you want a file that presents absolute definitions 
# corresponding to the pre-installation build tree,
# see ccaConfigTemporary.sh.

# If you want a file that presents relocatable definitions 
# suitable for makefile inclusions, see MakeIncl.CCA_Component.

#---------------------------------------------------------------
# CCA entire tree.
#---------------------------------------------------------------
CCA_ROOT='/usr/local/cca-spec'

#---------------------------------------------------------------
# CCA java tree: add this to classpath when building 
# CCA-dependent java components.
#---------------------------------------------------------------
CCA_JAVA_HOME='/usr/local/cca-spec/java'

#---------------------------------------------------------------
# CCA c++ tree and flags to digest headers while building 
# CCA-dependent c++ components.
#---------------------------------------------------------------
CCA_CXX_HOME='/usr/local/cca-spec/cxx'
CCA_INC='-I/usr/local/cca-spec/cxx/include'

#---------------------------------------------------------------
# CCA c++ lib with namespaces
#---------------------------------------------------------------
CCA_LIB='/usr/local/cca-spec/cxx/lib/libcca.a'


#---------------------------------------------------------------
# The compiler tools used to build CCA.
#---------------------------------------------------------------
CCA_CXX='c++'
CCA_JAVA='/usr/local/java/j2sdk1.4.0_01'

#---------------------------------------------------------------
# The compiler flags used to build CCA.
#---------------------------------------------------------------
CCA_CXX_FLAGS='-g -O2'


#----------------------------------------------------------------
# The following flags for dynamic loading lifted bodily
# from CCAFFEINE 10/2000.
#----------------------------------------------------------------
#
# NOTE: the authors of CCAFFEINE are *extremely* skeptical
# of all known automatic dynamic-loading dependency tracking
# (dynamic link resolution) schemes (most break readily).
#
# As such, our code is written to require FULL path names
# to .so files being loaded. The files are loaded privately
# (not into the global symbol table), with symbol access
# being explicitly through CCA_DynamicSymbol/dlsym.
#
# baa, 8/2000
#----------------------------------------------------------------


#       DL_LIBS -       System library(s) to include in demo and other base
#                       applications in order for the dynamic loading
#			to work.
CCA_DL_LIBS='-ldl'

#       LD_FLAGS -      Flags to pass to the compiler when linking object
#                       files static into an executable application binary.
CCA_LD_FLAGS='-rdynamic'

#       LD_SEARCH_FLAGS-Flags to pass to ld, such as "-R /usr/local/cca/lib",
#                       that tell the run-time dynamic linker where to look
#                       for components.  Depends on
#                       the variable LIB_RUNTIME_DIR in the Makefile.
# 			Not needed for absolute pathnamed files.
#			In ccaffeine, we force absolute pathnames.
CCA_LD_SEARCH_FLAGS='-Wl,-rpath,${LIB_RUNTIME_DIR}'

###
### Stuff for building components.
###

#       SHLIB_CFLAGS -  Flags to pass to cc when compiling .o files for
#                       a shared library (may request position-independent
#                       code, among other things).
CCA_SHLIB_CFLAGS='-fPIC'

#SHLIB_LD -      Base command to use for combining object files
#                into a shared library containing a component.
CCA_SHLIB_LD='c++ -shared'

#       SHLIB_LD_LIBS - Dependent libraries for the linker to scan when
#                       creating shared libraries.  This symbol typically
#                       goes at the end of the "ld" commands that build
#                       shared libraries. The value of the symbol is
#                       "${LIBS}" if all of the dependent libraries should
#                       be specified when creating a shared library.  If
#                       dependent libraries should not be specified (as on
#                       SunOS 4.x, where they cause the link to fail, or in
#                       general if demo mains aren't themselves shared
#                       libraries), then this symbol has an empty string
#                       as its value. Your component isn't a component
#                       (in CCA terms) if you need a non-empty value here.
CCA_SHLIB_LD_LIBS='-ldl '

#       SHLIB_SUFFIX -  Suffix to use for the names of dynamically loadable
#                       extensions.  An empty string means we don't know how
#                       to use shared libraries on this platform.
CCA_SHLIB_SUFFIX='.so'
