#ifndef ParameterGetListener_h_seen
#define ParameterGetListener_h_seen

class ConfigurableParameterPort;

  /** This interface is typically only implemented by the owner
      of a ConfigurableParameterPort instance. 
      The ParameterGet listeners
      on a ConfigurableParameterPort instance are called when
      the getConfigurationString function is called without a
      fieldName on the ParameterPort interface. 
      The listener (owner) can change the contents of the
      ConfigurableParameterPort; the updateParameterPort event
      is processed before the string answer is generated by
      getConfigurationString. This is handy
      when the contents of one ConfigurableParameterPort depend
      on values already set in another ConfigurableParameterPort
      on the same component. E.g. selection of a particular matrix
      prunes the list of options for the preconditioner when solving
      an iterative system. The fact that looking at a ParameterPort
      gives an opportunity for it to change may lead to Heisenbugs
      in the hands of an inept programmer.

      The argument cpp allows a listener/owner of a ConfigurableParameterPort
      to manage more than one. In this case, the updateParameterPort()
      implementation is responsible for discriminating.

      Returns TRUE if the owner changed the contents of the
      parameter list or wants fresh input.
     
      @see ParameterSetListener
  */
class ParameterGetListener {
public:
  virtual ~ParameterGetListener() {}
  
  /** Register a listener. */
  virtual bool updateParameterPort(ConfigurableParameterPort *cpp)=0;
};

#endif //ParameterGetListener_h_seen
