#ifndef __ConnectedConnectionEvent_h_seen__
#define __ConnectedConnectionEvent_h_seen__
/** Event delivered after a new connection has been made. */
class ConnectedConnectionEvent 
: public virtual ccafeopq::connectionevents::ConnectionEvent
{

private:
	// ::ccafeopq::PortInfo *pi;
	::ccafeopq::TypeMap_shared ctm;
	::std::string tpn;
	::std::string tpt;

public:
	ConnectedConnectionEvent( UserPortData & upd);
	ConnectedConnectionEvent( ProviderPortData & ppd);
	virtual ~ConnectedConnectionEvent();
  
	/** True if the event informs a connection. (always) */
	virtual int connected();
  
	/** True if the event informs a disconnection (never) */
	virtual int disconnected();
  
	virtual std::string getName();
	
	virtual std::string getType();

	/** properties of port */
	virtual ccafeopq::TypeMap_shared getProperties();



  virtual void * getOpqTypeMapSharedPtrAddress();
  
};
#endif // __ConnectedConnectionEvent_h_seen__

