#ifndef __CLASSICSERVICES_HH__
#define __CLASSICSERVICES_HH__

/** The handle through which the component communicates with its
    containing framework. */
class ClassicServices : public virtual classic::gov::cca::Services {
private:
      
  ccafeopq::Services* svc;

  virtual classic::gov::cca::Port *getPort_internal (const char *name);

  /** The fewer of these we must manage, the better.
   These are mapping functors.
   */
  std::map< std::string, ClassicPortConverter_shared > portConversions;

  /** Uses port wrapper data that come and go with get/release, some
     of which are generated by the portConversions.
   */
  std::map< std::string, classic::gov::cca::Port * > portAdapters;

  virtual void releasePort_internal (const std::string & name);

public:

  ClassicServices(ccafeopq::Services* svcs);

  /** obligatory virtual destructor */
  virtual ~ClassicServices();

  /** Creates a PortInfo to be used in subsequent
      calls to describe a Port. The arguments given are copied, not kept.
      properties is an even length list (argv) of key/value pairs 
      terminated by a NULL key. Note that names of Ports in a 
      component are not distinct for used and provided ports. 
      Standard properties: (UNADOPTED, extensible list)
      gov.cca.port.minConnections (int >= 0; default 0)
      gov.cca.port.maxConnections (int >= 1, default 1)
      gov.cca.port.proxyAllowed   (true,false; default false)
  */
  virtual classic::gov::cca::PortInfo *  createPortInfo(CONST char *name, 
	       		     CONST char *type, CONST char** properties);

  /**  Fetch a port from the framework. Normally this means a uses port.
       If no uses port is connected and a provided port of the name requested
       is available, the component will be handed back that port.
       Returns NULL if no provided port or uses port connection matches name.
        UNADOPTED C++ definition of "an error occurs".
  */
  virtual classic::gov::cca::Port * getPort(CONST char *name);

  /** get by string */
  virtual classic::gov::cca::Port *getPort (const std::string &n);


  /** Free's the port indicated by the instance name for modification
      by the component's containing framework.  After this call the
      port will not be valid for use until getPort() is called
      again.*/
  virtual void releasePort(CONST char *name);
  /** release by string. */
  virtual void releasePort (const std::string & name);

  /** Notifies the framework that a port described by PortInfo
      may be used by this component. The portinfo is obtained 
      from createPortInfo. Returns nonzero if there is an error
      in registering, such as bad PortInfo or already registered.
      UNADOPTED C++ definition of "an error occurs".
  */
  virtual int registerUsesPort(CDELETE classic::gov::cca::PortInfo 
			       *name_and_type);
  /** never returns nonzero. throws instead. */
  virtual int registerUsesPort(const std::string & name, const std::string & type);

  /** Notify the framework that a Port, previously
      registered by this component, is no longer desired.
      Returns nonzero if the port is still in use, ignoring
      the unregister request.
      UNADOPTED C++ definition of "an error occurs".
  */
  virtual int unregisterUsesPort(CONST char *name);
  /** unregister by string. never returns nonzero. throws instead. */
  virtual int unregisterUsesPort(const std::string & name);

  /** Exports a Port implemented by this component to the framework.  
      This Port is now available for the framework to
      connect to other components. The PortInfo is obtained 
      from createPortInfo. Returns nonzero if addProvidesPort fails,
      for example, because that name is already provided.
      UNADOPTED C++ definition of "an error occurs". */
  virtual int addProvidesPort(classic::gov::cca::Port *inPort, 
			      classic::gov::cca::PortInfo *name);
  /** add by strings. never returns nonzero. throws instead. */
  virtual int addProvidesPort(classic::gov::cca::Port *inPort, 
                              const std::string & name, const std::string & type);

  /** Notifies the framework that a previously exported Port is no longer 
      available for use. */
  virtual void removeProvidesPort(CONST char *name);
  /** remove by string. */
  virtual void removeProvidesPort(const std::string & name);

  /** Get a reference to the component which this 
      Services object belongs. */
  virtual CDELETE classic::gov::cca::ComponentID* getComponentID();

  /** Real components *never* use this function.
   * It's for framework testing purposes only.
   * The pointer returned must not be stored anywhere.
   */
  ::ccafeopq::Services *unwrapServices();

};

#endif // __CLASSICSERVICES_HH__
