#ifndef __TIMESTAMPSTRING_H__
#define __TIMESTAMPSTRING_H__

#include "gov/cca/cca.h"
#include "ccax/eg/port/StringConsumerPort.h"
#include "ccax/eg/port/TimeProducerPort.h"

using namespace gov::cca;

/** Inputs a string and stamps it before sending to the output. */
class TimeStamper: public Component, 
		   public StringConsumerPort {
		   
public:

  TimeStamper();

  virtual ~TimeStamper();

  /** Implements gov::cca::Component. */
  void setServices(Services *svc);

  /** Implements StringConsumerPort */
  virtual void setString(Cfree char* s);

private:
  Services* svc;
};

#endif // __TIMESTAMPSTRING_H__
